<?php include 'db.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $enabled = isset($_POST['enabled']) ? 1 : 0;
    $test_mode = isset($_POST['test_mode']) ? 1 : 0;
    $test_number = $_POST['test_number'];

    $conn->query("DELETE FROM settings");
    $stmt = $conn->prepare("INSERT INTO settings (enabled, test_mode, test_number) VALUES (?, ?, ?)");
    $stmt->bind_param("iis", $enabled, $test_mode, $test_number);
    $stmt->execute();
    echo "✅ Settings updated.";
} else {
    $row = $conn->query("SELECT * FROM settings LIMIT 1")->fetch_assoc();
    $enabled = $row['enabled'] ?? 1;
    $test_mode = $row['test_mode'] ?? 0;
    $test_number = $row['test_number'] ?? '';
?>
<form method="post">
    <label><input type="checkbox" name="enabled" value="1" <?= $enabled ? 'checked' : '' ?>> ✅ Enable Bot</label><br>
    <label><input type="checkbox" name="test_mode" value="1" <?= $test_mode ? 'checked' : '' ?>> 🧪 Test Mode</label><br>
    Allowed Number in Test Mode: <input name="test_number" value="<?= $test_number ?>"><br>
    <button type="submit">Save Settings</button>
</form>
<?php } ?>